import tkinter
import random
import copy

class Team():
    def __init__(self, canvas, meno_teamu="X", manazer=None, peniaze=0):
        self.canvas = canvas
        self.meno_teamu = meno_teamu
        self.manazer = manazer
        if(manazer is not None): self.auto = Auto(self.canvas, manazer.obr_c["oblecenie"])

        self.jazdci = []
        
        self.body = 0
        self.followeri = 10000
        self.peniaze = peniaze
        self.priemerne_umiestnenie = 0

        self.budovy = {"motoraren": Budova(self.canvas, "Motoraren", 35000000),
                       "PR_oddelenie": Budova(self.canvas, "PR Oddelenie", 15000000),
                       "veterny_tunel": Budova(self.canvas, "Veterny tunel", 45000000),
                       "simulator": Budova(self.canvas, "Simulator", 10000000)}

        #funkcie
        self.zisti_body()

    def set_up(self, meno_teamu, meno_manazera, followeri, peniaze, jazdci):
        self.meno_teamu = meno_teamu
        self.manazer = Jazdec(self.canvas, meno=meno_manazera)
        self.auto = Auto(self.canvas, self.manazer.obr_c["oblecenie"])
        self.followeri = followeri
        self.peniaze = peniaze
        
        for jazdec in jazdci:
            #nastavi jazdcovi jeho team a tricko vo farbe teamu
            jazdec.team = self
            jazdec.nastav_auto(self)
            jazdec.obr_c["oblecenie"] = self.manazer.obr_c["oblecenie"]
            self.jazdci += [jazdec]
            self.followeri += jazdec.followeri

        self.zisti_body()

        return self

    def vykresli_info_o_jazdcoch(self, x, y):
        jazdec_1, jazdec_2 = self.jazdci
        #vykreslenie
        self.canvas.create_text(x + 53, y - 20, text="Moji jazdci:", font="Ariel 15 bold")
        jazdec_1.vykresli_info_jazdca(x, y)
        jazdec_2.vykresli_info_jazdca(x, y+140)

    #def vykresli_info_o_jazdcoch_trening(self, x, y):
        

    def ulozit(self):
        retazec = ""

        if(self.meno_teamu == ""):
            self.meno_teamu = "NoTeamName"
            
        retazec += str(self.meno_teamu) + "^"
        retazec += self.manazer.ulozit() + "^"
        
        for jazdec in self.jazdci:
            retazec += jazdec.ulozit() + "??"

        retazec = retazec[:-2] + "^"

        retazec += self.auto.ulozit()

        retazec += "^"

        retazec += str(self.body) + ";"    
        retazec += str(self.followeri) + ";"
        retazec += str(self.peniaze) + ";"
        retazec += str(self.priemerne_umiestnenie)

        retazec += "^"

        retazec += str(self.budovy["motoraren"].ulozit())
        retazec += str(self.budovy["PR_oddelenie"].ulozit())
        retazec += str(self.budovy["veterny_tunel"].ulozit())
        retazec += str(self.budovy["simulator"].ulozit())

        return retazec[:-2]

    def nacitat(self, retazec):
        meno_teamu, manazer, jazdci, auto, atributy, budovy = retazec.split("^")

        self.meno_teamu = meno_teamu
        self.manazer = Jazdec(self.canvas).nacitat(manazer)
        self.auto = Auto(self.canvas, self.manazer.obr_c["oblecenie"]).nacitat(auto)

        jazdci = jazdci.split("??")
        self.jazdci = []
        for jazdec in jazdci:
            self.jazdci += [Jazdec(self.canvas, team=self).nacitat(jazdec)]


        body, followeri, peniaze, priemerne_hodnotenie = atributy.split(";")
        self.body, self.followeri, self.peniaze, self.priemerne_hodnotenie = int(body), int(followeri), int(peniaze), int(priemerne_hodnotenie)

        motoraren, PR_oddelenie, veterny_tunel, simulator = budovy.split("!!")
        self.budovy["motoraren"], self.budovy["PR_oddelenie"] = Budova(self.canvas).nacitat(motoraren), Budova(self.canvas).nacitat(PR_oddelenie)
        self.budovy["veterny_tunel"], self.budovy["simulator"] = Budova(self.canvas).nacitat(veterny_tunel), Budova(self.canvas).nacitat(simulator)

        return self

    def zisti_body(self):
        try:
            body = 0
            for jazdec in self.jazdci:
                body += jazdec.body
            self.body = body
        except:
            pass
        

class Jazdec():
    def __init__(self, canvas, meno="X", team=None, rychlost=0, preciznost=0, agresivita=0, manazment_pneumatik=0, followeri=0, hodnota=0, level=0, body=0, skusenosti=0):
        self.meno = meno
        self.team = team
        self.canvas = canvas
        if(team is not None):
            self.nastav_auto(team)
        
        self.rychlost = rychlost
        self.preciznost = preciznost
        self.agresivita = agresivita
        self.manazment_pneumatik = manazment_pneumatik
        
        self.followeri = followeri
        self.hodnota = hodnota
        self.AI = True
        self.faza_preteku = 0
        self.priemerne_umiestnenie = 0
        self.level = level
        self.body = body
        self.skusenosti = skusenosti
        self.potrebne_skusenosti = 100 * (1.5 ** level)
        self.moralka = 100
        self.umiestnenia = []
        
        self.nahodny_vyber()
        self.obrazky = dict()

        #Atributy k treningu a simulacii
        self.treningove_pneumatiky = ["S", "M", "H"]
        self.priemerna_spotreba = 0
        self.priemerna_pneumatika = {"S": -1, "M": -1, "H": -1}
        self.kolo = 0

        #atributy k pretekom
        self.celkovy_cas = 0
        self.posledne_kolo = 0 #predtym 9999
        self.najlepsie_kolo = -1 #predtym 0
        self.pozicia = -1
        self.je_trening = None
        self.str = True
        self.porucha = False
        self.pitstop = False
        self.pitstop_info = []
        self.cesta = []

    def nastav_auto_pred_treningom(self):
        pneu = random.choice(self.treningove_pneumatiky)
        self.auto.typ_pneumatiky = pneu

    def trening(self, opotrebenie, spotreba):
        tp = self.auto.typ_pneumatiky
        self.kolo += 1
        self.priemerna_pneumatika[tp] = ((self.kolo - 1) * self.priemerna_pneumatika[tp] + opotrebenie) / self.kolo
        self.priemerna_spotreba = ((self.kolo - 1) * self.priemerna_spotreba + spotreba) / self.kolo

        if(self.auto.palivo < 2 * self.priemerna_spotreba or self.auto.pneumatiky < 2 * self.priemerna_pneumatika[tp]):
            self.pitstop = True
            self.pitstop_info = [self.auto.typ_pneumatiky, int(100 - self.auto.palivo)]

        #UPRAV V SEZONE VOLANIE FUNKCIE
    def logika(self, pretek, kolo):
        if(pretek):
            print("- " + self.meno)
            #self.auto.vypis_info()
            try:
                pitstop_kolo = self.cesta[0][0]
                #print("CESTA: ", self.cesta)
            except:
                return
            if(kolo == pitstop_kolo):
                print(kolo, ". PITSTOP: ", self.meno)
                self.pitstop = True
                try:
                    _, pneumatiky, palivo = self.cesta[0]
                    self.pitstop_info = [pneumatiky, palivo]
                except:
                    _, palivo = self.cesta[0]
                    self.pitstop_info = [palivo]
                self.cesta.pop(0)
                print(self.pitstop_info)
                print(10 * "-")
        else:
            tp = self.auto.typ_pneumatiky
            if(self.auto.palivo < 2 * self.priemerna_spotreba or self.auto.pneumatiky < 2 * self.priemerna_pneumatika[tp]):
                self.pitstop = True
                self.pitstop_info = [self.auto.typ_pneumatiky, int(100 - self.auto.palivo)]
                print("MENO ---> ", self.meno)

    def strategia(self, trat):
        print(self.meno)
        self.str = False
        self.tmp_cas = -1
        self.cesta = []
        cesta = []
        
        def je_to_najlepsia_cesta(cas, cesta, kolo):
            if(self.tmp_cas == -1 or cas < self.tmp_cas):
                self.tmp_cas = cas
                self.cesta = cesta[:]
                
        def backtracking(kolo, cas, cesta):
            #JE PORUCHA?
            if(self.porucha):
                return

            tp = self.auto.typ_pneumatiky
            hladina_nadrze = [25,50,75,100]
            prirastok = 0
            cas_prirastok = 0
            self.pitstop = False
            while(self.auto.palivo > 3 * self.priemerna_spotreba and self.auto.pneumatiky > 3 * self.priemerna_pneumatika[tp]):
                if(kolo + prirastok > 65):
                    je_to_najlepsia_cesta(cas, cesta, kolo+prirastok)
                    return
                cas_prirastok += trat.prejdi_kolo(self, True, kolo)
                prirastok += 1
            
            #Treba menit pneu?
            if(self.auto.pneumatiky > 50 + 3 * self.priemerna_pneumatika[tp]):
                treba_pneu = False
            else:
                treba_pneu = True

            #Treba dotankovat?
            if(self.auto.palivo > 50 + 3 * self.priemerna_spotreba):
                hladina_nadrze = [0]
            
            for palivo in hladina_nadrze:
                if(treba_pneu):
                    for typ_pneu in ["S", "M", "H"]:
                        self.pitstop = True
                        pal = self.auto.palivo
                        pne = self.auto.pneumatiky
                        cesta += [[kolo + prirastok, typ_pneu, palivo]]
                        self.pitstop_info = [typ_pneu, palivo]
                        
                        cas_kolo = trat.prejdi_kolo(self, True, kolo)
                        backtracking(kolo + prirastok + 1, cas + cas_prirastok + cas_kolo, cesta)

                        self.porucha = False
                        self.auto.palivo = pal
                        self.auto.pneumatiky = pne
                        cesta.pop()
                else:
                    self.pitstop = True
                    cesta += [[kolo, palivo]]
                    self.pitstop_info = [palivo]
                    
                    cas_kolo = trat.prejdi_kolo(self, True, kolo)
                    backtracking(kolo + prirastok + 1, cas + cas_prirastok + cas_kolo, cesta)

                    cesta.pop()     
            
        backtracking(0, 0, cesta)

        print("S: ", self.cesta)
        self.str = True
        self.reset_faza()
        

    def reset_faza(self):
        self.kolo = 0
        self.celkovy_cas = -1
        self.posledne_kolo = 9999
        self.najlepsie_kolo = -1 #bolo predtym 0
        self.pozicia = -1
        self.porucha = False
        self.pitstop = False
        self.pitstop_info = []
        try:
            self.treningove_pneumatiky.remove(self.auto.typ_pneumatiky)
        except:
            pass
        self.auto.reset()

    def reset_preteky(self):
        self.reset_faza()
        self.treningove_pneumatiky = ["S", "M", "H"]
        self.priemerna_spotreba = 0
        self.priemerna_pneumatika = {"S": -1, "M": -1, "H": -1}

    def kvalifikacny_rezim(self, kolo):
        self.auto.pritlak = 1
        self.auto.palivo = 91 - kolo * 6
        self.auto.pneumatiky = 100
        self.typ_pneumatiky = "S"

    def nastav_auto(self, team):
        rych = team.auto.max_rychlost
        zrych = team.auto.zrychlenie
        self.auto = Auto(self.canvas, 0, max_rychlost=rych, zrychlenie=zrych)

    def update_kolo(self, cas):
        #Poruchy
        if(cas == -1):
            self.najlepsie_kolo = 9999
            self.celkovy_cas = 99999
            self.porucha = True
        #Vsetko v poriadku
        else:
            self.posledne_kolo = cas
            if(self.najlepsie_kolo == -1 or self.posledne_kolo < self.najlepsie_kolo):
                self.najlepsie_kolo = self.posledne_kolo
            self.celkovy_cas += self.posledne_kolo

    def update_pozicia(self, pozicia):
        self.pozicia = pozicia

    def cas(self, kolo):
        if(not self.porucha):
            minuty = kolo // 60
            kolo = kolo - 60*minuty
            sekundy = int(kolo)
            milisekundy = kolo - sekundy

            return "{}:{:02},{:03}".format(int(minuty), int(sekundy), int(round(milisekundy, 3)*1000))
        else:
            return "Na:Na:Na"

    def nacitat(self, retazec):
        atributy, statistiky, trening, obrazky, umiestnenia = retazec.strip().split("#")
        
        meno, rychlost, preciznost, agresivita, manazment_pneumatik = atributy.split(";")
        body, followeri, hodnota, priemerne_umiestnenie, level, skusenosti, moralka = statistiky.split(";")
        tr_pneu, pr_spot, priemer_pneu = trening.split(";")
        telo, oblecenie, usta, oci, vlasy = obrazky.split(";")

        self.meno, self.rychlost, self.preciznost, self.agresivita, self.manazment_pneumatik = meno, int(rychlost), int(preciznost), int(agresivita), int(manazment_pneumatik)
        self.body, self.followeri, self.hodnota, self.priemerne_umiestnenie, self.level, self.skusenosti, self.moralka = int(body), int(followeri), int(hodnota), int(priemerne_umiestnenie), int(level), int(skusenosti), int(moralka) #, bool(AI)

        self.treningove_pneumatiky = []
        for typ in tr_pneu:
            self.treningove_pneumatiky += [typ]
        self.priemerna_spotreba = float(pr_spot)
        
        for pneu in priemer_pneu.split(","):
            kluc, hodnota = pneu.split(">")
            self.priemerna_pneumatika[kluc] = float(hodnota)
            
        self.obr_c["telo"], self.obr_c["oblecenie"], self.obr_c["usta"], self.obr_c["oci"], self.obr_c["vlasy"] = int(telo), int(oblecenie), int(usta), int(oci), int(vlasy)
        
        for miesto in umiestnenia.split(";"):
            try:
                self.umiestnenia += [int(miesto.strip())]
            except:
                pass

        return self
    
    def ulozit(self):
        retazec = ""

        if(self.meno == ""):
            self.meno = "NoName"
            
        retazec += str(self.meno) + ";"    
        retazec += str(self.rychlost) + ";"
        retazec += str(self.preciznost) + ";"
        retazec += str(self.agresivita) + ";"
        retazec += str(self.manazment_pneumatik)

        retazec += "#"

        retazec += str(self.body) + ";"
        retazec += str(self.followeri) + ";"
        retazec += str(self.hodnota) + ";"
        retazec += str(self.priemerne_umiestnenie) + ";"
        retazec += str(self.level) + ";"
        retazec += str(self.skusenosti) + ";"
        retazec += str(self.moralka)
        #retazec += str(self.moralka) + ";"
        #retazec += str(self.AI)

        retazec += "#"

        for typ in self.treningove_pneumatiky:
            retazec += str(typ)
        retazec += ";"
        retazec += str(self.priemerna_spotreba) + ";"
        for typ in self.priemerna_pneumatika:
            retazec += typ + ">" + str(self.priemerna_pneumatika[typ]) + ","

        retazec = retazec[:-1] + "#"

        retazec += str(self.obr_c["telo"]) + ";"
        retazec += str(self.obr_c["oblecenie"]) + ";"
        retazec += str(self.obr_c["usta"]) + ";"
        retazec += str(self.obr_c["oci"]) + ";"
        retazec += str(self.obr_c["vlasy"])

        retazec += "#"

        if(self.umiestnenia == []):
            return retazec
        else:
            for miesto in self.umiestnenia:
                retazec += str(miesto) + ";"
        
            return retazec[:-1] 

    def level_up(self):
        if(self.skusenosti >= self.potrebne_skusenosti):
            self.level += 1
            self.skusenosti -= self.potrebne_skusenosti
            self.potrebne_skusenosti = int(self.potrebne_skusenosti * 1.5)

    def aktualizuj_obrazky(self, zmensi):
        self.obrazky["telo"] = tkinter.PhotoImage(file="obrazky\\jazdec\\telo\\telo-{}.png".format(self.obr_c["telo"])).subsample(zmensi,zmensi)
        self.obrazky["oblecenie"] = tkinter.PhotoImage(file="obrazky\jazdec\oblecenie\oblecenie-{}.png".format(self.obr_c["oblecenie"])).subsample(zmensi,zmensi)
        self.obrazky["usta"] = tkinter.PhotoImage(file="obrazky\jazdec\\usta\\usta-{}.png".format(self.obr_c["usta"])).subsample(zmensi,zmensi)
        self.obrazky["oci"] = tkinter.PhotoImage(file="obrazky\jazdec\\oci\\oci-{}.png".format(self.obr_c["oci"])).subsample(zmensi,zmensi)
        self.obrazky["vlasy"] = tkinter.PhotoImage(file="obrazky\jazdec\\vlasy\\vlasy-{}.png".format(self.obr_c["vlasy"])).subsample(zmensi,zmensi)

    def vykresli(self, x, y, zmensi=1):
        self.aktualizuj_obrazky(zmensi)
        self.canvas.create_image(x, y, image=self.obrazky["telo"])
        self.canvas.create_image(x, y, image=self.obrazky["oblecenie"])
        self.canvas.create_image(x, y, image=self.obrazky["usta"])
        self.canvas.create_image(x, y, image=self.obrazky["oci"])
        self.canvas.create_image(x, y, image=self.obrazky["vlasy"])

    def vykresli_info_jazdca(self, x, y):
        #vykresli ramcek s udajmi o hracovi
        self.canvas.create_rectangle(x, y, x + 380, y + 140, width=2)
        self.canvas.create_text(x + 80, y + 15, font="Ariel 14 bold", text=self.meno)
        self.vykresli(x + 80, y + 75, 3)
        #farba
        farba="red"
        if(self.moralka >= 110):
            farba = "green"
        if(self.moralka <= 90):
            farba = "yellow"
        #rychlost
        self.canvas.create_text(x + 210, y + 15, text="Rychlost: {}".format(self.rychlost), font="Ariel 11")
        self.canvas.create_rectangle(x + 160, y + 25, x + 160 + int(2 * self.rychlost), y + 35, fill=farba)
        self.canvas.create_rectangle(x + 160, y + 25, x + 360, y + 35)
        #preciznost
        self.canvas.create_text(x + 210, y + 45, text="Preciznost: {}".format(self.preciznost), font="Ariel 11")
        self.canvas.create_rectangle(x + 160, y + 55, x + 160 + int(2 * self.preciznost), y + 65, fill=farba)
        self.canvas.create_rectangle(x + 160, y + 55, x + 360, y + 65)
        #agresivita
        self.canvas.create_text(x + 210, y + 75, text="Agresivita: {}".format(self.agresivita), font="Ariel 11")
        self.canvas.create_rectangle(x + 160, y + 85, x + 160 + int(2 * self.agresivita), y + 95, fill=farba)
        self.canvas.create_rectangle(x + 160, y + 85, x + 360, y + 95)
        #manazment_pneumatik
        self.canvas.create_text(x + 250, y + 105, text="Manazment pneumatik: {}".format(self.manazment_pneumatik), font="Ariel 11")
        self.canvas.create_rectangle(x + 160, y + 115, x + 160 + int(2 * self.manazment_pneumatik), y + 125, fill=farba)
        self.canvas.create_rectangle(x + 160, y + 115, x + 360, y + 125)
        

    def nahodny_vyber(self):
        self.obr_c = {"telo": random.randint(1,4),
                      "oblecenie": random.randint(1,14),
                      "oci": random.randint(1,14),
                      "usta": random.randint(1,14),
                      "vlasy": random.randint(1,14)}

    def nastav_obrazok(self, druh, zmena):
        self.obr_c[druh] += zmena
        print(druh, zmena, self.obr_c[druh])
        
        if(self.obr_c[druh] == 0):
            self.obr_c[druh] = 1
            
        if(self.obr_c["telo"] == 5):
            self.obr_c["telo"] = 4
            return
        if(self.obr_c[druh] == 15):
            self.obr_c[druh] = 14

class Auto():
    def __init__(self, canvas, obr, max_rychlost=330, pneumatiky=100, zrychlenie=10, palivo=100):
        #self.jazdec = jazdec
        self.canvas = canvas
        self.obr = obr
        
        #info o aute
        self.max_rychlost = max_rychlost
        self.zrychlenie = zrychlenie
        self.predne_kridlo = 10
        self.zadne_kridlo = 10
        self.nastav_aerodynamiku()

        #info k pretekom
        self.typ_pneumatiky = "S"
        self.pneumatiky = pneumatiky
        
        self.palivo = palivo
        self.pritlak = 50

    def reset(self):
        self.nastav_aerodynamiku()
        self.typ_pneumatiky = "S"
        self.palivo = 100
        self.pneumatiky = 100

    def nastav_aerodynamiku(self):
        self.aerodynamika = self.predne_kridlo + self.zadne_kridlo

    def vypis_info(self):
        print("    PALIVO:", self.palivo)
        print("PNEUMATIKY:", self.pneumatiky)
        print("TYP_PNEUMA:", self.typ_pneumatiky)

    def ulozit(self):
        retazec = ""

        retazec += str(self.max_rychlost) + ";"
        retazec += str(self.zrychlenie) + ";"
        retazec += str(self.predne_kridlo) + ";"
        retazec += str(self.zadne_kridlo)

        retazec += "!!"

        retazec += str(self.typ_pneumatiky) + ";"
        retazec += str(self.pneumatiky) + ";"
        retazec += str(self.palivo) + ";"
        retazec += str(self.pritlak)

        return retazec

    def nacitat(self, retazec):
        info_auto, info_pretek = retazec.split("!!")

        max_rych, zrych, p_kridlo, z_kridlo = info_auto.split(";")
        t_pneu, pneu, palivo, pritlak = info_pretek.split(";")

        self.max_rychlost, self.zrychlenie, self.predne_kridlo, self.zadne_krislo = int(max_rych), int(zrych), int(p_kridlo), int(z_kridlo)
        self.typ_pneumatiky, self.pneumatiky, self.palivo, self.pritlak = str(t_pneu), int(pneu), int(palivo), int(pritlak)
        self.nastav_aerodynamiku()

        return self

##    def prejdi_kolo(self):
##        if(self.aktualne_kolo < self.najlepsie_kolo or self.najlepsie_kolo == -1):
##            self.najlepsie_kolo = self.aktualne_kolo
##            self.najlepsi_pritlak = self.pritlak
##            
##        self.celkovy_cas += self.aktualne_kolo
##        self.aktualne_kolo = 0
##
##    def cas_reset(self):
##        self.najlepsie_kolo = -1
##        self.aktualne_kolo = 0
##        self.celkovy_cas = 0

    def vykresli_auto_info(self, x, y):
        #zaklad
        self.canvas.create_text(x + 55, y - 20, text="Info o aute:", font="Ariel 15 bold")
        self.canvas.create_rectangle(x, y, x + 380, y + 280, width=2)
        #obrazok
        self.obrazok = tkinter.PhotoImage(file="obrazky\\formula\\formula-{}.png".format(self.obr)).subsample(2,2)
        self.canvas.create_image(x + 190, y + 85, image=self.obrazok)
        #max rychlost
        self.canvas.create_text(x + 95, y + 180, text="Maximalna rychlost:", font="Ariel 12")
        self.canvas.create_text(x + 95, y + 200, text="{}".format(self.max_rychlost), font="Ariel 12 bold")
        #zrychlenie
        self.canvas.create_text(x + 95, y + 230, text="Zrychlenie: {}".format(self.zrychlenie), font="Ariel 12")
        self.canvas.create_rectangle(x + 20, y + 245, x + 20 + int(1.5 * self.zrychlenie), y + 255, fill="red")
        self.canvas.create_rectangle(x + 20, y + 245, x + 170, y + 255)
        #zadne kridlo
        self.canvas.create_text(x + 285, y + 180, text="Zadne kridlo: {}".format(self.zadne_kridlo), font="Ariel 12")
        self.canvas.create_rectangle(x + 210, y + 195, x + 210 + int(1.5 * self.zadne_kridlo), y + 205, fill="red")
        self.canvas.create_rectangle(x + 210, y + 195, x + 360, y + 205)
        #predne kridlo
        self.canvas.create_text(x + 285, y + 230, text="Predne kridlo: {}".format(self.predne_kridlo), font="Ariel 12")
        self.canvas.create_rectangle(x + 210, y + 245, x + 210 + int(1.5 * self.predne_kridlo), y + 255, fill="red")
        self.canvas.create_rectangle(x + 210, y + 245, x + 360, y + 255)

    def vykresli_auto_info_pretek(self, x, y):
        #zaklad
        self.canvas.create_rectangle(x, y, x+320, y+140, width=2)
        #Palivo
        x_palivo = self.palivo * 3
        self.canvas.create_text(x+85, y+15, text="Palivo: {:3}/100".format(int(self.palivo)), font="Ariel 15 bold")
        self.canvas.create_rectangle(x+10, y+30, x+10+x_palivo, y+50, fill="red")
        self.canvas.create_rectangle(x+10, y+30, x+310, y+50, outline="black")
        #Pneumatiky
        x_pneumatiky = self.pneumatiky * 3
        self.canvas.create_text(x+105, y+85, text="Pneumatiky: {:3}/100".format(int(self.pneumatiky)), font="Ariel 15 bold")
        self.obrazok_pneumatiky = tkinter.PhotoImage(file="obrazky\\pneumatika\\pneumatika-{}.png".format(self.typ_pneumatiky)).subsample(4,4)
        self.canvas.create_image(x + 250, y+85, image=self.obrazok_pneumatiky)
        self.canvas.create_rectangle(x+10, y+100, x+10+x_pneumatiky, y+120, fill="red")
        self.canvas.create_rectangle(x+10, y+100, x+310, y+120, outline="black")
        


class Budova():
    def __init__(self, canvas, meno="XX", cena=0, pocet_zamestnancov=0, level=1):
        self.canvas = canvas
        self.meno = meno
        self.cena = cena

        self.pocet_zamestnancov = pocet_zamestnancov
        self.level = level

        self.ziskany_pokrok = 0
        self.potrebny_pokrok = 1000

    def ulozit(self):
        retazec = ""

        retazec += str(self.meno) + ";"
        retazec += str(self.cena) + ";"
        retazec += str(self.pocet_zamestnancov) + ";"
        retazec += str(self.level) + ";"
        retazec += str(self.ziskany_pokrok) + ";"
        retazec += str(self.potrebny_pokrok) + "!!"

        return retazec      

    def nacitat(self, retazec):
        meno, cena, poc_zam, level, z_pok, p_pok = retazec.split(";")
        self.nazov, self.cena, self.pocet_zamestnancov = str(meno), int(cena), int(poc_zam)
        self.level, self.ziskany_pokrok, self.potrebny_pokrok = int(level), int(z_pok), int(p_pok)

        return self


































